/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.rhapsody.kafka.sending;

import com.expediagroup.rhapsody.api.AbstractAcknowledgeable;
import com.expediagroup.rhapsody.api.Acknowledgeable;
import com.expediagroup.rhapsody.api.AcknowledgeableFactory;
import com.expediagroup.rhapsody.api.ComposedAcknowledgeable;
import java.util.function.Consumer;
import org.apache.kafka.clients.producer.RecordMetadata;
import reactor.kafka.sender.SenderResult;

public class AcknowledgeableSenderResult<T>
extends AbstractAcknowledgeable<SenderResult<T>>
implements SenderResult<T> {
    private final Acknowledgeable<T> acknowledgeable;
    private final SenderResult senderResult;

    private AcknowledgeableSenderResult(Acknowledgeable<T> acknowledgeable, SenderResult senderResult) {
        this.acknowledgeable = acknowledgeable;
        this.senderResult = senderResult;
    }

    public static <T> AcknowledgeableSenderResult<T> fromSenderResult(SenderResult<Acknowledgeable<T>> senderResult) {
        return new AcknowledgeableSenderResult<T>((Acknowledgeable)senderResult.correlationMetadata(), senderResult);
    }

    public String toString() {
        return String.format("senderResult=%s acknowledgeable=%s", this.senderResult, this.acknowledgeable);
    }

    public SenderResult<T> get() {
        return this;
    }

    public Runnable getAcknowledger() {
        return this.acknowledgeable.getAcknowledger();
    }

    public Consumer<? super Throwable> getNacknowledger() {
        return this.acknowledgeable.getNacknowledger();
    }

    public RecordMetadata recordMetadata() {
        return this.senderResult.recordMetadata();
    }

    public Exception exception() {
        return this.senderResult.exception();
    }

    public T correlationMetadata() {
        return (T)this.acknowledgeable.get();
    }

    protected <R> AcknowledgeableFactory<R> createPropagator() {
        return ComposedAcknowledgeable::new;
    }
}

