/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.SpecificationMatchUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.DomainKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.Domain;
import java.util.function.Predicate;

public class DomainFilter
implements Predicate<Domain> {
    private final DomainKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public DomainFilter(DomainKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(Domain d) {
        if (this.keyQuery != null && !FilterUtility.matches(d.getKey().getName(), this.keyQuery.getNameRegex())) {
            return false;
        }
        return SpecificationMatchUtility.matchesSpecification(d.getSpecification(), this.specQuery);
    }
}

