/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.SpecificationMatchUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ProducerKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import java.util.function.Predicate;

public class ProducerFilter
implements Predicate<Producer> {
    private final ProducerKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public ProducerFilter(ProducerKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(Producer d) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(d.getKey().getName(), this.keyQuery.getNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getStreamDomain(), this.keyQuery.getStreamDomainRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getStreamName(), this.keyQuery.getStreamNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getZone(), this.keyQuery.getZoneRegex())) {
                return false;
            }
            if (this.keyQuery.getStreamVersion() != null && d.getKey().getStreamVersion() != this.keyQuery.getStreamVersion()) {
                return false;
            }
        }
        return SpecificationMatchUtility.matchesSpecification(d.getSpecification(), this.specQuery);
    }
}

