/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.SpecificationMatchUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SchemaKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.Schema;
import java.util.function.Predicate;

public class SchemaFilter
implements Predicate<Schema> {
    private final SchemaKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public SchemaFilter(SchemaKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(Schema d) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(d.getKey().getName(), this.keyQuery.getNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getDomain(), this.keyQuery.getDomainRegex())) {
                return false;
            }
        }
        return SpecificationMatchUtility.matchesSpecification(d.getSpecification(), this.specQuery);
    }
}

