/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.SpecificationMatchUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SchemaKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.StreamKeyQuery;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import java.util.function.Predicate;

public class StreamFilter
implements Predicate<Stream> {
    private final StreamKeyQuery keyQuery;
    private final SpecificationQuery specQuery;
    private final SchemaKeyQuery schemaQuery;

    public StreamFilter(StreamKeyQuery keyQuery, SpecificationQuery specQuery, SchemaKeyQuery schemaQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
        this.schemaQuery = schemaQuery;
    }

    @Override
    public boolean test(Stream stream) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(stream.getKey().getName(), this.keyQuery.getNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(stream.getKey().getDomain(), this.keyQuery.getDomainRegex())) {
                return false;
            }
            if (this.keyQuery.getVersion() != null && stream.getKey().getVersion() != this.keyQuery.getVersion()) {
                return false;
            }
        }
        return SpecificationMatchUtility.matchesSpecification(stream.getSpecification(), this.specQuery);
    }
}

