/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.TagQuery;
import com.expediagroup.streamplatform.streamregistry.model.Specification;
import com.expediagroup.streamplatform.streamregistry.model.Tag;
import java.util.List;

public class TagMatchUtility {
    public static boolean matchesAllTagQueries(Specification specification, List<TagQuery> tagQueries) {
        return TagMatchUtility.matchesAllTagQueries(specification == null ? null : specification.getTags(), tagQueries);
    }

    private static boolean matchesAllTagQueries(List<Tag> tags, List<TagQuery> tagQueries) {
        if (tagQueries == null || tagQueries.isEmpty()) {
            return true;
        }
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        for (TagQuery tagQuery : tagQueries) {
            if (TagMatchUtility.matchesAnyTag(tags, tagQuery)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesAnyTag(List<Tag> tags, TagQuery tagQuery) {
        for (Tag tag : tags) {
            if (!TagMatchUtility.matchesTag(tag, tagQuery)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesTag(Tag tag, TagQuery tagQuery) {
        if (tagQuery.getNameRegex() != null && !tag.getName().matches(tagQuery.getNameRegex())) {
            return false;
        }
        return tagQuery.getValueRegex() == null || tag.getValue().matches(tagQuery.getValueRegex());
    }
}

