/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.SpecificationMatchUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ZoneKeyQuery;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import java.util.function.Predicate;

public class ZoneFilter
implements Predicate<Zone> {
    private final ZoneKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public ZoneFilter(ZoneKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(Zone zone) {
        if (this.keyQuery != null && !FilterUtility.matches(zone.getKey().getName(), this.keyQuery.getNameRegex())) {
            return false;
        }
        return SpecificationMatchUtility.matchesSpecification(zone.getSpecification(), this.specQuery);
    }
}

