/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.InfrastructureService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.InfrastructureKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.InfrastructureMutation;
import com.expediagroup.streamplatform.streamregistry.model.Infrastructure;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class InfrastructureMutationImpl
implements InfrastructureMutation {
    private final InfrastructureService infrastructureService;

    @Override
    public Infrastructure insert(InfrastructureKeyInput key, SpecificationInput specification) {
        return (Infrastructure)this.infrastructureService.create(this.asInfrastructure(key, specification)).get();
    }

    @Override
    public Infrastructure update(InfrastructureKeyInput key, SpecificationInput specification) {
        return (Infrastructure)this.infrastructureService.update(this.asInfrastructure(key, specification)).get();
    }

    @Override
    public Infrastructure upsert(InfrastructureKeyInput key, SpecificationInput specification) {
        return (Infrastructure)this.infrastructureService.upsert(this.asInfrastructure(key, specification)).get();
    }

    @Override
    public Boolean delete(InfrastructureKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public Infrastructure updateStatus(InfrastructureKeyInput key, StatusInput status) {
        Infrastructure infrastructure = (Infrastructure)this.infrastructureService.read(key.asInfrastructureKey()).get();
        infrastructure.setStatus(status.asStatus());
        return (Infrastructure)this.infrastructureService.update(infrastructure).get();
    }

    private Infrastructure asInfrastructure(InfrastructureKeyInput key, SpecificationInput specification) {
        Infrastructure out = new Infrastructure();
        out.setKey(key.asInfrastructureKey());
        out.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)out, this.infrastructureService.read(out.getKey()));
        return out;
    }

    @ConstructorProperties(value={"infrastructureService"})
    public InfrastructureMutationImpl(InfrastructureService infrastructureService) {
        this.infrastructureService = infrastructureService;
    }
}

