/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.StreamBindingService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StreamBindingKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.StreamBindingMutation;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class StreamBindingMutationImpl
implements StreamBindingMutation {
    private final StreamBindingService streamBindingService;

    @Override
    public StreamBinding insert(StreamBindingKeyInput key, SpecificationInput specification) {
        return (StreamBinding)this.streamBindingService.create(this.asStreamBinding(key, specification)).get();
    }

    @Override
    public StreamBinding update(StreamBindingKeyInput key, SpecificationInput specification) {
        return (StreamBinding)this.streamBindingService.update(this.asStreamBinding(key, specification)).get();
    }

    @Override
    public StreamBinding upsert(StreamBindingKeyInput key, SpecificationInput specification) {
        return (StreamBinding)this.streamBindingService.upsert(this.asStreamBinding(key, specification)).get();
    }

    @Override
    public Boolean delete(StreamBindingKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public StreamBinding updateStatus(StreamBindingKeyInput key, StatusInput status) {
        StreamBinding streamBinding = (StreamBinding)this.streamBindingService.read(key.asStreamBindingKey()).get();
        streamBinding.setStatus(status.asStatus());
        return (StreamBinding)this.streamBindingService.update(streamBinding).get();
    }

    private StreamBinding asStreamBinding(StreamBindingKeyInput key, SpecificationInput specification) {
        StreamBinding streamBinding = new StreamBinding();
        streamBinding.setKey(key.asStreamBindingKey());
        streamBinding.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)streamBinding, this.streamBindingService.read(streamBinding.getKey()));
        return streamBinding;
    }

    @ConstructorProperties(value={"streamBindingService"})
    public StreamBindingMutationImpl(StreamBindingService streamBindingService) {
        this.streamBindingService = streamBindingService;
    }
}

