/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ZoneService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ZoneKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.ZoneMutation;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ZoneMutationImpl
implements ZoneMutation {
    private final ZoneService zoneService;

    @Override
    public Zone insert(ZoneKeyInput key, SpecificationInput specification) {
        return (Zone)this.zoneService.create(this.asZone(key, specification)).get();
    }

    @Override
    public Zone update(ZoneKeyInput key, SpecificationInput specification) {
        return (Zone)this.zoneService.update(this.asZone(key, specification)).get();
    }

    @Override
    public Zone upsert(ZoneKeyInput key, SpecificationInput specification) {
        return (Zone)this.zoneService.upsert(this.asZone(key, specification)).get();
    }

    @Override
    public Boolean delete(ZoneKeyInput key) {
        throw new UnsupportedOperationException("deleteZone");
    }

    @Override
    public Zone updateStatus(ZoneKeyInput key, StatusInput status) {
        Zone zone = (Zone)this.zoneService.read(key.asZoneKey()).get();
        zone.setStatus(status.asStatus());
        return (Zone)this.zoneService.update(zone).get();
    }

    private Zone asZone(ZoneKeyInput key, SpecificationInput specification) {
        Zone zone = new Zone();
        zone.setKey(key.asZoneKey());
        zone.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)zone, this.zoneService.read(zone.getKey()));
        return zone;
    }

    @ConstructorProperties(value={"zoneService"})
    public ZoneMutationImpl(ZoneService zoneService) {
        this.zoneService = zoneService;
    }
}

