/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.query.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerService;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.ConsumerFilter;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ConsumerKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ConsumerKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.query.ConsumerQuery;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class ConsumerQueryImpl
implements ConsumerQuery {
    private final ConsumerService consumerService;

    @Override
    public Optional<Consumer> byKey(ConsumerKeyInput key) {
        return this.consumerService.read(key.asConsumerKey());
    }

    @Override
    public Iterable<Consumer> byQuery(ConsumerKeyQuery key, SpecificationQuery specification) {
        return this.consumerService.findAll((Predicate)new ConsumerFilter(key, specification));
    }

    @ConstructorProperties(value={"consumerService"})
    public ConsumerQueryImpl(ConsumerService consumerService) {
        this.consumerService = consumerService;
    }
}

