/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.query.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.InfrastructureService;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.InfrastructureFilter;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.InfrastructureKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.InfrastructureKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.query.InfrastructureQuery;
import com.expediagroup.streamplatform.streamregistry.model.Infrastructure;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class InfrastructureQueryImpl
implements InfrastructureQuery {
    private final InfrastructureService infrastructureService;

    @Override
    public Optional<Infrastructure> byKey(InfrastructureKeyInput key) {
        return this.infrastructureService.read(key.asInfrastructureKey());
    }

    @Override
    public Iterable<Infrastructure> byQuery(InfrastructureKeyQuery key, SpecificationQuery specification) {
        return this.infrastructureService.findAll((Predicate)new InfrastructureFilter(key, specification));
    }

    @ConstructorProperties(value={"infrastructureService"})
    public InfrastructureQueryImpl(InfrastructureService infrastructureService) {
        this.infrastructureService = infrastructureService;
    }
}

