/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.query.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.SchemaService;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.SchemaFilter;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SchemaKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SchemaKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.query.SchemaQuery;
import com.expediagroup.streamplatform.streamregistry.model.Schema;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class SchemaQueryImpl
implements SchemaQuery {
    private final SchemaService schemaService;

    @Override
    public Optional<Schema> byKey(SchemaKeyInput key) {
        return this.schemaService.read(key.asSchemaKey());
    }

    @Override
    public Iterable<Schema> byQuery(SchemaKeyQuery key, SpecificationQuery specification) {
        return this.schemaService.findAll((Predicate)new SchemaFilter(key, specification));
    }

    @ConstructorProperties(value={"schemaService"})
    public SchemaQueryImpl(SchemaService schemaService) {
        this.schemaService = schemaService;
    }
}

