/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.query.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.StreamFilter;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StreamKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SchemaKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.StreamKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.query.StreamQuery;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class StreamQueryImpl
implements StreamQuery {
    private final StreamService streamService;

    @Override
    public Optional<Stream> byKey(StreamKeyInput key) {
        return this.streamService.read(key.asStreamKey());
    }

    @Override
    public Iterable<Stream> byQuery(StreamKeyQuery key, SpecificationQuery specification, SchemaKeyQuery schemaKeyQuery) {
        return this.streamService.findAll((Predicate)new StreamFilter(key, specification, schemaKeyQuery));
    }

    @ConstructorProperties(value={"streamService"})
    public StreamQueryImpl(StreamService streamService) {
        this.streamService = streamService;
    }
}

