/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamBindingService;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Status;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import com.expediagroup.streamplatform.streamregistry.model.keys.ConsumerKey;
import com.expediagroup.streamplatform.streamregistry.model.keys.StreamBindingKey;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ConsumerBindingResolver
implements GraphQLResolver<ConsumerBinding> {
    private final ConsumerService consumerService;
    private final StreamBindingService streamBindingService;

    public Consumer consumer(ConsumerBinding consumerBinding) {
        ConsumerKey consumerKey = new ConsumerKey(consumerBinding.getKey().getStreamDomain(), consumerBinding.getKey().getStreamName(), consumerBinding.getKey().getStreamVersion(), consumerBinding.getKey().getInfrastructureZone(), consumerBinding.getKey().getConsumerName());
        return this.consumerService.read(consumerKey).orElse(null);
    }

    public StreamBinding binding(ConsumerBinding consumerBinding) {
        StreamBindingKey streamBindingKey = new StreamBindingKey(consumerBinding.getKey().getStreamDomain(), consumerBinding.getKey().getStreamName(), consumerBinding.getKey().getStreamVersion(), consumerBinding.getKey().getInfrastructureZone(), consumerBinding.getKey().getInfrastructureName());
        return this.streamBindingService.read(streamBindingKey).orElse(null);
    }

    public Status status(ConsumerBinding consumerBinding) {
        return consumerBinding.getStatus() == null ? new Status() : consumerBinding.getStatus();
    }

    @ConstructorProperties(value={"consumerService", "streamBindingService"})
    public ConsumerBindingResolver(ConsumerService consumerService, StreamBindingService streamBindingService) {
        this.consumerService = consumerService;
        this.streamBindingService = streamBindingService;
    }
}

