/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerBindingService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.core.services.ZoneService;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Status;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import com.expediagroup.streamplatform.streamregistry.model.keys.StreamKey;
import com.expediagroup.streamplatform.streamregistry.model.keys.ZoneKey;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Component;

@Component
public class ConsumerResolver
implements GraphQLResolver<Consumer> {
    private final StreamService streamService;
    private final ZoneService zoneService;
    private final ConsumerBindingService consumerBindingService;

    public Stream stream(Consumer consumer) {
        StreamKey streamKey = new StreamKey(consumer.getKey().getStreamDomain(), consumer.getKey().getStreamName(), consumer.getKey().getStreamVersion());
        return this.streamService.read(streamKey).orElse(null);
    }

    public Zone zone(Consumer consumer) {
        ZoneKey zoneKey = new ZoneKey(consumer.getKey().getZone());
        return this.zoneService.read(zoneKey).orElse(null);
    }

    public Optional<ConsumerBinding> binding(Consumer consumer) {
        Predicate<ConsumerBinding> predicate = binding -> binding.getKey().getConsumerKey().equals((Object)consumer.getKey());
        return StreamSupport.stream(this.consumerBindingService.findAll(predicate).spliterator(), false).findFirst();
    }

    public Status status(Consumer consumer) {
        return consumer.getStatus() == null ? new Status() : consumer.getStatus();
    }

    @ConstructorProperties(value={"streamService", "zoneService", "consumerBindingService"})
    public ConsumerResolver(StreamService streamService, ZoneService zoneService, ConsumerBindingService consumerBindingService) {
        this.streamService = streamService;
        this.zoneService = zoneService;
        this.consumerBindingService = consumerBindingService;
    }
}

