/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.expediagroup.streamplatform.streamregistry.core.services.ProducerService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamBindingService;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import com.expediagroup.streamplatform.streamregistry.model.ProducerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Status;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import com.expediagroup.streamplatform.streamregistry.model.keys.ProducerKey;
import com.expediagroup.streamplatform.streamregistry.model.keys.StreamBindingKey;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ProducerBindingResolver
implements GraphQLResolver<ProducerBinding> {
    private final ProducerService producerService;
    private final StreamBindingService streamBindingService;

    public Producer producer(ProducerBinding producerBinding) {
        ProducerKey producerKey = new ProducerKey(producerBinding.getKey().getStreamDomain(), producerBinding.getKey().getStreamName(), producerBinding.getKey().getStreamVersion(), producerBinding.getKey().getInfrastructureZone(), producerBinding.getKey().getProducerName());
        return this.producerService.read(producerKey).orElse(null);
    }

    public StreamBinding binding(ProducerBinding producerBinding) {
        StreamBindingKey streamBindingKey = new StreamBindingKey(producerBinding.getKey().getStreamDomain(), producerBinding.getKey().getStreamName(), producerBinding.getKey().getStreamVersion(), producerBinding.getKey().getInfrastructureZone(), producerBinding.getKey().getInfrastructureName());
        return this.streamBindingService.read(streamBindingKey).orElse(null);
    }

    public Status status(ProducerBinding producerBinding) {
        return producerBinding.getStatus() == null ? new Status() : producerBinding.getStatus();
    }

    @ConstructorProperties(value={"producerService", "streamBindingService"})
    public ProducerBindingResolver(ProducerService producerService, StreamBindingService streamBindingService) {
        this.producerService = producerService;
        this.streamBindingService = streamBindingService;
    }
}

