/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.expediagroup.streamplatform.streamregistry.core.services.ProducerBindingService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.core.services.ZoneService;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import com.expediagroup.streamplatform.streamregistry.model.ProducerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Status;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import com.expediagroup.streamplatform.streamregistry.model.keys.StreamKey;
import com.expediagroup.streamplatform.streamregistry.model.keys.ZoneKey;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Component;

@Component
public class ProducerResolver
implements GraphQLResolver<Producer> {
    private final StreamService streamService;
    private final ZoneService zoneService;
    private final ProducerBindingService producerBindingService;

    public Stream stream(Producer producer) {
        StreamKey streamKey = new StreamKey(producer.getKey().getStreamDomain(), producer.getKey().getStreamName(), producer.getKey().getStreamVersion());
        return (Stream)this.streamService.read(streamKey).get();
    }

    public Zone zone(Producer producer) {
        ZoneKey zoneKey = new ZoneKey(producer.getKey().getZone());
        return this.zoneService.read(zoneKey).orElse(null);
    }

    public Optional<ProducerBinding> binding(Producer producer) {
        Predicate<ProducerBinding> predicate = binding -> binding.getKey().getProducerKey().equals((Object)producer.getKey());
        return StreamSupport.stream(this.producerBindingService.findAll(predicate).spliterator(), false).findFirst();
    }

    public Status status(Producer producer) {
        return producer.getStatus() == null ? new Status() : producer.getStatus();
    }

    @ConstructorProperties(value={"streamService", "zoneService", "producerBindingService"})
    public ProducerResolver(StreamService streamService, ZoneService zoneService, ProducerBindingService producerBindingService) {
        this.streamService = streamService;
        this.zoneService = zoneService;
        this.producerBindingService = producerBindingService;
    }
}

