/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.expediagroup.streamplatform.streamregistry.core.services.InfrastructureService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.model.Infrastructure;
import com.expediagroup.streamplatform.streamregistry.model.Status;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import com.expediagroup.streamplatform.streamregistry.model.keys.InfrastructureKey;
import com.expediagroup.streamplatform.streamregistry.model.keys.StreamKey;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class StreamBindingResolver
implements GraphQLResolver<StreamBinding> {
    private final StreamService streamService;
    private final InfrastructureService infrastructureService;

    public Stream stream(StreamBinding streamBinding) {
        StreamKey streamKey = new StreamKey(streamBinding.getKey().getStreamDomain(), streamBinding.getKey().getStreamName(), streamBinding.getKey().getStreamVersion());
        return this.streamService.read(streamKey).orElse(null);
    }

    public Infrastructure infrastructure(StreamBinding streamBinding) {
        InfrastructureKey infrastructureKey = new InfrastructureKey(streamBinding.getKey().getInfrastructureZone(), streamBinding.getKey().getInfrastructureName());
        return this.infrastructureService.read(infrastructureKey).orElse(null);
    }

    public Status status(StreamBinding streamBinding) {
        return streamBinding.getStatus() == null ? new Status() : streamBinding.getStatus();
    }

    @ConstructorProperties(value={"streamService", "infrastructureService"})
    public StreamBindingResolver(StreamService streamService, InfrastructureService infrastructureService) {
        this.streamService = streamService;
        this.infrastructureService = infrastructureService;
    }
}

