/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql;

import com.expediagroup.streamplatform.streamregistry.graphql.GraphQLApiType;
import com.expediagroup.streamplatform.streamregistry.graphql.GraphQLMetricHandler;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class GraphQLBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(GraphQLBeanPostProcessor.class);
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof GraphQLApiType) {
            MeterRegistry registry = (MeterRegistry)this.applicationContext.getBean(MeterRegistry.class);
            Class<?>[] interfaces = bean.getClass().getInterfaces();
            GraphQLMetricHandler handler = new GraphQLMetricHandler(bean, registry);
            log.debug("Proxying {} with GraphQLMetricHandler", (Object)beanName);
            bean = Proxy.newProxyInstance(GraphQLMetricHandler.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

