/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql;

import com.google.common.base.Stopwatch;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

class GraphQLMetricHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphQLMetricHandler.class);
    private final Object delegate;
    private final MeterRegistry registry;
    private final Supplier<Authentication> authenticationSupplier;

    public GraphQLMetricHandler(Object delegate, MeterRegistry registry) {
        this(delegate, registry, () -> SecurityContextHolder.getContext().getAuthentication());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        boolean success = false;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Object result = method.invoke(this.delegate, args);
            success = true;
            object = result;
        }
        catch (InvocationTargetException e) {
            try {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            catch (Throwable throwable) {
                Tags tags = Tags.of((String)"api", (String)method.getDeclaringClass().getSimpleName()).and("method", method.getName()).and("result", success ? "success" : "failure").and("authentication_group", AuthenticationGroup.of(this.authenticationSupplier.get()).name());
                this.registry.timer("graphql_api", (Iterable)tags).record(stopwatch.elapsed());
                throw throwable;
            }
        }
        Tags tags = Tags.of((String)"api", (String)method.getDeclaringClass().getSimpleName()).and("method", method.getName()).and("result", success ? "success" : "failure").and("authentication_group", AuthenticationGroup.of(this.authenticationSupplier.get()).name());
        this.registry.timer("graphql_api", (Iterable)tags).record(stopwatch.elapsed());
        return object;
    }

    @ConstructorProperties(value={"delegate", "registry", "authenticationSupplier"})
    GraphQLMetricHandler(Object delegate, MeterRegistry registry, Supplier<Authentication> authenticationSupplier) {
        this.delegate = delegate;
        this.registry = registry;
        this.authenticationSupplier = authenticationSupplier;
    }

    Object getDelegate() {
        return this.delegate;
    }

    MeterRegistry getRegistry() {
        return this.registry;
    }

    Supplier<Authentication> getAuthenticationSupplier() {
        return this.authenticationSupplier;
    }

    static enum AuthenticationGroup {
        AUTHENTICATED,
        ANONYMOUS;


        static AuthenticationGroup of(Authentication authentication) {
            if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
                return ANONYMOUS;
            }
            return AUTHENTICATED;
        }
    }
}

