/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ConsumerBindingKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import java.util.function.Predicate;

public class ConsumerBindingFilter
implements Predicate<ConsumerBinding> {
    private final ConsumerBindingKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public ConsumerBindingFilter(ConsumerBindingKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(ConsumerBinding d) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(d.getKey().getInfrastructureName(), this.keyQuery.getInfrastructureNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getInfrastructureZone(), this.keyQuery.getInfrastructureZoneRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getStreamDomain(), this.keyQuery.getStreamDomainRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getStreamName(), this.keyQuery.getStreamNameRegex())) {
                return false;
            }
            if (this.keyQuery.getStreamVersion() != null && d.getKey().getStreamVersion() != this.keyQuery.getStreamVersion()) {
                return false;
            }
        }
        return FilterUtility.matchesSpecification(d.getSpecification(), this.specQuery);
    }
}

