/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ConsumerKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import java.util.function.Predicate;

public class ConsumerFilter
implements Predicate<Consumer> {
    private final ConsumerKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public ConsumerFilter(ConsumerKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(Consumer consumer) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(consumer.getKey().getName(), this.keyQuery.getNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(consumer.getKey().getStreamDomain(), this.keyQuery.getStreamDomainRegex())) {
                return false;
            }
            if (!FilterUtility.matches(consumer.getKey().getStreamName(), this.keyQuery.getStreamNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(consumer.getKey().getZone(), this.keyQuery.getZoneRegex())) {
                return false;
            }
            if (this.keyQuery.getStreamVersion() != null && consumer.getKey().getStreamVersion() != this.keyQuery.getStreamVersion()) {
                return false;
            }
        }
        return FilterUtility.matchesSpecification(consumer.getSpecification(), this.specQuery);
    }
}

