/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.TagMatchUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SchemaKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.Specification;
import com.expediagroup.streamplatform.streamregistry.model.keys.SchemaKey;

public class FilterUtility {
    public static boolean matches(String nullableValue, String nullableRegex) {
        if (nullableValue == null) {
            return nullableRegex == null;
        }
        return nullableRegex == null || nullableValue.matches(nullableRegex);
    }

    public static boolean matchesInt(Integer value, Integer required) {
        return required == null || required.equals(value);
    }

    public static boolean matchesSpecification(Specification specification, SpecificationQuery specQuery) {
        if (specQuery == null) {
            return true;
        }
        if (specification == null) {
            return false;
        }
        if (!FilterUtility.matches(specification.getDescription(), specQuery.getDescriptionRegex())) {
            return false;
        }
        if (!FilterUtility.matches(specification.getType(), specQuery.getTypeRegex())) {
            return false;
        }
        return TagMatchUtility.matchesAllTagQueries(specification, specQuery.getTags());
    }

    public static boolean matchesSchemaKey(SchemaKey key, SchemaKeyQuery schemaKeyQuery) {
        if (schemaKeyQuery == null) {
            return true;
        }
        if (!FilterUtility.matches(key.getDomain(), schemaKeyQuery.getDomainRegex())) {
            return false;
        }
        return FilterUtility.matches(key.getName(), schemaKeyQuery.getNameRegex());
    }
}

