/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.InfrastructureKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.model.Infrastructure;
import java.util.function.Predicate;

public class InfrastructureFilter
implements Predicate<Infrastructure> {
    private final InfrastructureKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public InfrastructureFilter(InfrastructureKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(Infrastructure d) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(d.getKey().getName(), this.keyQuery.getNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getZone(), this.keyQuery.getZoneRegex())) {
                return false;
            }
        }
        return FilterUtility.matchesSpecification(d.getSpecification(), this.specQuery);
    }
}

