/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.StreamBindingKeyQuery;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import java.util.function.Predicate;

public class StreamBindingFilter
implements Predicate<StreamBinding> {
    private final StreamBindingKeyQuery keyQuery;
    private final SpecificationQuery specQuery;

    public StreamBindingFilter(StreamBindingKeyQuery keyQuery, SpecificationQuery specQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
    }

    @Override
    public boolean test(StreamBinding d) {
        if (this.keyQuery != null) {
            if (!FilterUtility.matches(d.getKey().getInfrastructureName(), this.keyQuery.getInfrastructureNameRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getInfrastructureZone(), this.keyQuery.getInfrastructureZoneRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getStreamDomain(), this.keyQuery.getStreamDomainRegex())) {
                return false;
            }
            if (!FilterUtility.matches(d.getKey().getStreamName(), this.keyQuery.getStreamNameRegex())) {
                return false;
            }
            if (this.keyQuery.getStreamVersion() != null && d.getKey().getStreamVersion() != this.keyQuery.getStreamVersion()) {
                return false;
            }
        }
        return FilterUtility.matchesSpecification(d.getSpecification(), this.specQuery);
    }
}

