/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.filters;

import com.expediagroup.streamplatform.streamregistry.graphql.filters.FilterUtility;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SchemaKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.StreamKeyQuery;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.keys.StreamKey;
import java.util.function.Predicate;

public class StreamFilter
implements Predicate<Stream> {
    private final StreamKeyQuery keyQuery;
    private final SpecificationQuery specQuery;
    private final SchemaKeyQuery schemaKeyQuery;

    public StreamFilter(StreamKeyQuery keyQuery, SpecificationQuery specQuery, SchemaKeyQuery schemaKeyQuery) {
        this.keyQuery = keyQuery;
        this.specQuery = specQuery;
        this.schemaKeyQuery = schemaKeyQuery;
    }

    @Override
    public boolean test(Stream stream) {
        return StreamFilter.matchesStreamKey(stream.getKey(), this.keyQuery) && FilterUtility.matchesSchemaKey(stream.getSchemaKey(), this.schemaKeyQuery) && FilterUtility.matchesSpecification(stream.getSpecification(), this.specQuery);
    }

    public static boolean matchesStreamKey(StreamKey key, StreamKeyQuery streamKeyQuery) {
        if (streamKeyQuery == null) {
            return true;
        }
        return FilterUtility.matches(key.getDomain(), streamKeyQuery.getDomainRegex()) && FilterUtility.matches(key.getName(), streamKeyQuery.getNameRegex()) && FilterUtility.matchesInt(key.getVersion(), streamKeyQuery.getVersion());
    }
}

