/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.model.inputs;

import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.NameNormaliser;
import com.expediagroup.streamplatform.streamregistry.model.keys.ConsumerKey;
import java.beans.ConstructorProperties;

public final class ConsumerKeyInput {
    private final String streamDomain;
    private final String streamName;
    private final Integer streamVersion;
    private final String zone;
    private final String name;

    public ConsumerKey asConsumerKey() {
        return new ConsumerKey(NameNormaliser.normalise(this.streamDomain), NameNormaliser.normalise(this.streamName), this.streamVersion, NameNormaliser.normalise(this.zone), NameNormaliser.normalise(this.name));
    }

    @ConstructorProperties(value={"streamDomain", "streamName", "streamVersion", "zone", "name"})
    ConsumerKeyInput(String streamDomain, String streamName, Integer streamVersion, String zone, String name) {
        this.streamDomain = streamDomain;
        this.streamName = streamName;
        this.streamVersion = streamVersion;
        this.zone = zone;
        this.name = name;
    }

    public static ConsumerKeyInputBuilder builder() {
        return new ConsumerKeyInputBuilder();
    }

    public String getStreamDomain() {
        return this.streamDomain;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Integer getStreamVersion() {
        return this.streamVersion;
    }

    public String getZone() {
        return this.zone;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerKeyInput)) {
            return false;
        }
        ConsumerKeyInput other = (ConsumerKeyInput)o;
        String this$streamDomain = this.getStreamDomain();
        String other$streamDomain = other.getStreamDomain();
        if (this$streamDomain == null ? other$streamDomain != null : !this$streamDomain.equals(other$streamDomain)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        Integer this$streamVersion = this.getStreamVersion();
        Integer other$streamVersion = other.getStreamVersion();
        if (this$streamVersion == null ? other$streamVersion != null : !((Object)this$streamVersion).equals(other$streamVersion)) {
            return false;
        }
        String this$zone = this.getZone();
        String other$zone = other.getZone();
        if (this$zone == null ? other$zone != null : !this$zone.equals(other$zone)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streamDomain = this.getStreamDomain();
        result = result * 59 + ($streamDomain == null ? 43 : $streamDomain.hashCode());
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        Integer $streamVersion = this.getStreamVersion();
        result = result * 59 + ($streamVersion == null ? 43 : ((Object)$streamVersion).hashCode());
        String $zone = this.getZone();
        result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerKeyInput(streamDomain=" + this.getStreamDomain() + ", streamName=" + this.getStreamName() + ", streamVersion=" + this.getStreamVersion() + ", zone=" + this.getZone() + ", name=" + this.getName() + ")";
    }

    public static class ConsumerKeyInputBuilder {
        private String streamDomain;
        private String streamName;
        private Integer streamVersion;
        private String zone;
        private String name;

        ConsumerKeyInputBuilder() {
        }

        public ConsumerKeyInputBuilder streamDomain(String streamDomain) {
            this.streamDomain = streamDomain;
            return this;
        }

        public ConsumerKeyInputBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public ConsumerKeyInputBuilder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        public ConsumerKeyInputBuilder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public ConsumerKeyInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConsumerKeyInput build() {
            return new ConsumerKeyInput(this.streamDomain, this.streamName, this.streamVersion, this.zone, this.name);
        }

        public String toString() {
            return "ConsumerKeyInput.ConsumerKeyInputBuilder(streamDomain=" + this.streamDomain + ", streamName=" + this.streamName + ", streamVersion=" + this.streamVersion + ", zone=" + this.zone + ", name=" + this.name + ")";
        }
    }
}

