/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.model.inputs;

import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.TagInput;
import com.expediagroup.streamplatform.streamregistry.model.Specification;
import com.expediagroup.streamplatform.streamregistry.model.Tag;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;

public final class SpecificationInput {
    private final String description;
    private final List<TagInput> tags;
    private final String type;
    private final ObjectNode configuration;

    private static List<Tag> getTags(List<TagInput> input) {
        ArrayList<Tag> out = new ArrayList<Tag>();
        if (input != null) {
            for (TagInput t : input) {
                out.add(new Tag(t.getName(), t.getValue()));
            }
        }
        return out;
    }

    public Specification asSpecification() {
        return new Specification(this.description, SpecificationInput.getTags(this.tags), this.type, this.configuration);
    }

    @ConstructorProperties(value={"description", "tags", "type", "configuration"})
    SpecificationInput(String description, List<TagInput> tags, String type, ObjectNode configuration) {
        this.description = description;
        this.tags = tags;
        this.type = type;
        this.configuration = configuration;
    }

    public static SpecificationInputBuilder builder() {
        return new SpecificationInputBuilder();
    }

    public String getDescription() {
        return this.description;
    }

    public List<TagInput> getTags() {
        return this.tags;
    }

    public String getType() {
        return this.type;
    }

    public ObjectNode getConfiguration() {
        return this.configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecificationInput)) {
            return false;
        }
        SpecificationInput other = (SpecificationInput)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<TagInput> this$tags = this.getTags();
        List<TagInput> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ObjectNode this$configuration = this.getConfiguration();
        ObjectNode other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<TagInput> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ObjectNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    public String toString() {
        return "SpecificationInput(description=" + this.getDescription() + ", tags=" + this.getTags() + ", type=" + this.getType() + ", configuration=" + this.getConfiguration() + ")";
    }

    public static class SpecificationInputBuilder {
        private String description;
        private List<TagInput> tags;
        private String type;
        private ObjectNode configuration;

        SpecificationInputBuilder() {
        }

        public SpecificationInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SpecificationInputBuilder tags(List<TagInput> tags) {
            this.tags = tags;
            return this;
        }

        public SpecificationInputBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SpecificationInputBuilder configuration(ObjectNode configuration) {
            this.configuration = configuration;
            return this;
        }

        public SpecificationInput build() {
            return new SpecificationInput(this.description, this.tags, this.type, this.configuration);
        }

        public String toString() {
            return "SpecificationInput.SpecificationInputBuilder(description=" + this.description + ", tags=" + this.tags + ", type=" + this.type + ", configuration=" + this.configuration + ")";
        }
    }
}

