/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerBindingService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ConsumerBindingKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.ConsumerBindingMutation;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ConsumerBindingMutationImpl
implements ConsumerBindingMutation {
    private final ConsumerBindingService consumerBindingService;

    @Override
    public ConsumerBinding insert(ConsumerBindingKeyInput key, SpecificationInput specification) {
        return (ConsumerBinding)this.consumerBindingService.create(this.asConsumerBinding(key, specification)).get();
    }

    @Override
    public ConsumerBinding update(ConsumerBindingKeyInput key, SpecificationInput specification) {
        return (ConsumerBinding)this.consumerBindingService.update(this.asConsumerBinding(key, specification)).get();
    }

    @Override
    public ConsumerBinding upsert(ConsumerBindingKeyInput key, SpecificationInput specification) {
        return (ConsumerBinding)this.consumerBindingService.upsert(this.asConsumerBinding(key, specification)).get();
    }

    @Override
    public Boolean delete(ConsumerBindingKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public ConsumerBinding updateStatus(ConsumerBindingKeyInput key, StatusInput status) {
        ConsumerBinding consumerBinding = (ConsumerBinding)this.consumerBindingService.read(key.asConsumerBindingKey()).get();
        consumerBinding.setStatus(status.asStatus());
        return (ConsumerBinding)this.consumerBindingService.update(consumerBinding).get();
    }

    private ConsumerBinding asConsumerBinding(ConsumerBindingKeyInput key, SpecificationInput specification) {
        ConsumerBinding consumerBinding = new ConsumerBinding();
        consumerBinding.setKey(key.asConsumerBindingKey());
        consumerBinding.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)consumerBinding, this.consumerBindingService.read(key.asConsumerBindingKey()));
        return consumerBinding;
    }

    @ConstructorProperties(value={"consumerBindingService"})
    public ConsumerBindingMutationImpl(ConsumerBindingService consumerBindingService) {
        this.consumerBindingService = consumerBindingService;
    }
}

