/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ConsumerKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.ConsumerMutation;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ConsumerMutationImpl
implements ConsumerMutation {
    private final ConsumerService consumerService;

    @Override
    public Consumer insert(ConsumerKeyInput key, SpecificationInput specification) {
        return (Consumer)this.consumerService.create(this.asConsumer(key, specification)).get();
    }

    @Override
    public Consumer update(ConsumerKeyInput key, SpecificationInput specification) {
        return (Consumer)this.consumerService.update(this.asConsumer(key, specification)).get();
    }

    @Override
    public Consumer upsert(ConsumerKeyInput key, SpecificationInput specification) {
        return (Consumer)this.consumerService.upsert(this.asConsumer(key, specification)).get();
    }

    @Override
    public Boolean delete(ConsumerKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public Consumer updateStatus(ConsumerKeyInput key, StatusInput status) {
        Consumer consumer = (Consumer)this.consumerService.read(key.asConsumerKey()).get();
        consumer.setStatus(status.asStatus());
        return (Consumer)this.consumerService.update(consumer).get();
    }

    private Consumer asConsumer(ConsumerKeyInput key, SpecificationInput specification) {
        Consumer consumer = new Consumer();
        consumer.setKey(key.asConsumerKey());
        consumer.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)consumer, this.consumerService.read(consumer.getKey()));
        return consumer;
    }

    @ConstructorProperties(value={"consumerService"})
    public ConsumerMutationImpl(ConsumerService consumerService) {
        this.consumerService = consumerService;
    }
}

