/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.DomainService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.DomainKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.DomainMutation;
import com.expediagroup.streamplatform.streamregistry.model.Domain;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class DomainMutationImpl
implements DomainMutation {
    private final DomainService domainService;

    @Override
    public Domain insert(DomainKeyInput key, SpecificationInput specification) {
        return (Domain)this.domainService.create(this.asDomain(key, specification)).get();
    }

    @Override
    public Domain update(DomainKeyInput key, SpecificationInput specification) {
        return (Domain)this.domainService.update(this.asDomain(key, specification)).get();
    }

    @Override
    public Domain upsert(DomainKeyInput key, SpecificationInput specification) {
        return (Domain)this.domainService.upsert(this.asDomain(key, specification)).get();
    }

    @Override
    public Boolean delete(DomainKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public Domain updateStatus(DomainKeyInput key, StatusInput status) {
        Domain domain = (Domain)this.domainService.read(key.asDomainKey()).get();
        domain.setStatus(status.asStatus());
        return (Domain)this.domainService.update(domain).get();
    }

    private Domain asDomain(DomainKeyInput key, SpecificationInput specification) {
        Domain domain = new Domain();
        domain.setKey(key.asDomainKey());
        domain.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)domain, this.domainService.read(domain.getKey()));
        return domain;
    }

    @ConstructorProperties(value={"domainService"})
    public DomainMutationImpl(DomainService domainService) {
        this.domainService = domainService;
    }
}

