/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ProducerService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ProducerKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.ProducerMutation;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ProducerMutationImpl
implements ProducerMutation {
    private final ProducerService producerService;

    @Override
    public Producer insert(ProducerKeyInput key, SpecificationInput specification) {
        return (Producer)this.producerService.create(this.asProducer(key, specification)).get();
    }

    @Override
    public Producer update(ProducerKeyInput key, SpecificationInput specification) {
        return (Producer)this.producerService.update(this.asProducer(key, specification)).get();
    }

    @Override
    public Producer upsert(ProducerKeyInput key, SpecificationInput specification) {
        return (Producer)this.producerService.upsert(this.asProducer(key, specification)).get();
    }

    @Override
    public Boolean delete(ProducerKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public Producer updateStatus(ProducerKeyInput key, StatusInput status) {
        Producer producer = (Producer)this.producerService.read(key.asProducerKey()).get();
        producer.setStatus(status.asStatus());
        return (Producer)this.producerService.update(producer).get();
    }

    private Producer asProducer(ProducerKeyInput key, SpecificationInput specification) {
        Producer producer = new Producer();
        producer.setKey(key.asProducerKey());
        producer.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)producer, this.producerService.read(producer.getKey()));
        return producer;
    }

    @ConstructorProperties(value={"producerService"})
    public ProducerMutationImpl(ProducerService producerService) {
        this.producerService = producerService;
    }
}

