/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.SchemaService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SchemaKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.SchemaMutation;
import com.expediagroup.streamplatform.streamregistry.model.Schema;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class SchemaMutationImpl
implements SchemaMutation {
    private final SchemaService schemaService;

    @Override
    public Schema insert(SchemaKeyInput key, SpecificationInput specification) {
        return (Schema)this.schemaService.create(this.asSchema(key, specification)).get();
    }

    @Override
    public Schema update(SchemaKeyInput key, SpecificationInput specification) {
        return (Schema)this.schemaService.update(this.asSchema(key, specification)).get();
    }

    @Override
    public Schema upsert(SchemaKeyInput key, SpecificationInput specification) {
        return (Schema)this.schemaService.upsert(this.asSchema(key, specification)).get();
    }

    @Override
    public Boolean delete(SchemaKeyInput key) {
        throw new UnsupportedOperationException("delete");
    }

    @Override
    public Schema updateStatus(SchemaKeyInput key, StatusInput status) {
        Schema schema = (Schema)this.schemaService.read(key.asSchemaKey()).get();
        schema.setStatus(status.asStatus());
        return (Schema)this.schemaService.update(schema).get();
    }

    private Schema asSchema(SchemaKeyInput key, SpecificationInput specification) {
        Schema schema = new Schema();
        schema.setKey(key.asSchemaKey());
        schema.setSpecification(specification.asSpecification());
        StateHelper.maintainState((Stated)schema, this.schemaService.read(schema.getKey()));
        return schema;
    }

    @ConstructorProperties(value={"schemaService"})
    public SchemaMutationImpl(SchemaService schemaService) {
        this.schemaService = schemaService;
    }
}

