/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.mutation.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.graphql.StateHelper;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SchemaKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.SpecificationInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StatusInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.StreamKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.mutation.StreamMutation;
import com.expediagroup.streamplatform.streamregistry.model.Stated;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class StreamMutationImpl
implements StreamMutation {
    private final StreamService streamService;

    @Override
    public Stream insert(StreamKeyInput key, SpecificationInput specification, SchemaKeyInput schema) {
        return (Stream)this.streamService.create(this.asStream(key, specification, Optional.of(schema))).get();
    }

    @Override
    public Stream update(StreamKeyInput key, SpecificationInput specification) {
        return (Stream)this.streamService.update(this.asStream(key, specification, Optional.empty())).get();
    }

    @Override
    public Stream upsert(StreamKeyInput key, SpecificationInput specification, SchemaKeyInput schema) {
        return (Stream)this.streamService.upsert(this.asStream(key, specification, Optional.ofNullable(schema))).get();
    }

    @Override
    public Boolean delete(StreamKeyInput key) {
        throw new UnsupportedOperationException("deleteStream");
    }

    @Override
    public Stream updateStatus(StreamKeyInput key, StatusInput status) {
        Stream stream = (Stream)this.streamService.read(key.asStreamKey()).get();
        stream.setStatus(status.asStatus());
        return (Stream)this.streamService.update(stream).get();
    }

    private Stream asStream(StreamKeyInput key, SpecificationInput specification, Optional<SchemaKeyInput> schema) {
        Stream stream = new Stream();
        stream.setKey(key.asStreamKey());
        stream.setSpecification(specification.asSpecification());
        if (schema.isPresent()) {
            stream.setSchemaKey(schema.get().asSchemaKey());
        }
        StateHelper.maintainState((Stated)stream, this.streamService.read(stream.getKey()));
        return stream;
    }

    @ConstructorProperties(value={"streamService"})
    public StreamMutationImpl(StreamService streamService) {
        this.streamService = streamService;
    }
}

