/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.query.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ProducerService;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.ProducerFilter;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ProducerKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ProducerKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.query.ProducerQuery;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class ProducerQueryImpl
implements ProducerQuery {
    private final ProducerService producerService;

    @Override
    public Optional<Producer> byKey(ProducerKeyInput key) {
        return this.producerService.read(key.asProducerKey());
    }

    @Override
    public Iterable<Producer> byQuery(ProducerKeyQuery key, SpecificationQuery specification) {
        return this.producerService.findAll((Predicate)new ProducerFilter(key, specification));
    }

    @ConstructorProperties(value={"producerService"})
    public ProducerQueryImpl(ProducerService producerService) {
        this.producerService = producerService;
    }
}

