/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.query.impl;

import com.expediagroup.streamplatform.streamregistry.core.services.ZoneService;
import com.expediagroup.streamplatform.streamregistry.graphql.filters.ZoneFilter;
import com.expediagroup.streamplatform.streamregistry.graphql.model.inputs.ZoneKeyInput;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.SpecificationQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.model.queries.ZoneKeyQuery;
import com.expediagroup.streamplatform.streamregistry.graphql.query.ZoneQuery;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class ZoneQueryImpl
implements ZoneQuery {
    private final ZoneService zoneService;

    @Override
    public Optional<Zone> byKey(ZoneKeyInput key) {
        return this.zoneService.read(key.asZoneKey());
    }

    @Override
    public Iterable<Zone> byQuery(ZoneKeyQuery key, SpecificationQuery specification) {
        return this.zoneService.findAll((Predicate)new ZoneFilter(key, specification));
    }

    @ConstructorProperties(value={"zoneService"})
    public ZoneQueryImpl(ZoneService zoneService) {
        this.zoneService = zoneService;
    }
}

