/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamBindingService;
import com.expediagroup.streamplatform.streamregistry.graphql.resolvers.Resolvers;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ConsumerBindingResolver
implements Resolvers.ConsumerBindingResolver {
    private final ConsumerService consumerService;
    private final StreamBindingService streamBindingService;

    @Override
    public Consumer consumer(ConsumerBinding consumerBinding) {
        return this.consumerService.read(consumerBinding.getKey().getConsumerKey()).orElse(null);
    }

    @Override
    public StreamBinding binding(ConsumerBinding consumerBinding) {
        return this.streamBindingService.read(consumerBinding.getKey().getStreamBindingKey()).orElse(null);
    }

    @ConstructorProperties(value={"consumerService", "streamBindingService"})
    public ConsumerBindingResolver(ConsumerService consumerService, StreamBindingService streamBindingService) {
        this.consumerService = consumerService;
        this.streamBindingService = streamBindingService;
    }
}

