/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.core.services.ConsumerBindingService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.core.services.ZoneService;
import com.expediagroup.streamplatform.streamregistry.graphql.resolvers.Resolvers;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ConsumerResolver
implements Resolvers.ConsumerResolver {
    private final StreamService streamService;
    private final ZoneService zoneService;
    private final ConsumerBindingService consumerBindingService;

    @Override
    public Stream stream(Consumer consumer) {
        return this.streamService.read(consumer.getKey().getStreamKey()).orElse(null);
    }

    @Override
    public Zone zone(Consumer consumer) {
        return this.zoneService.read(consumer.getKey().getZoneKey()).orElse(null);
    }

    @Override
    public ConsumerBinding binding(Consumer consumer) {
        return this.consumerBindingService.find(consumer.getKey()).orElse(null);
    }

    @ConstructorProperties(value={"streamService", "zoneService", "consumerBindingService"})
    public ConsumerResolver(StreamService streamService, ZoneService zoneService, ConsumerBindingService consumerBindingService) {
        this.streamService = streamService;
        this.zoneService = zoneService;
        this.consumerBindingService = consumerBindingService;
    }
}

