/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.core.services.ProducerService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamBindingService;
import com.expediagroup.streamplatform.streamregistry.graphql.resolvers.Resolvers;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import com.expediagroup.streamplatform.streamregistry.model.ProducerBinding;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ProducerBindingResolver
implements Resolvers.ProducerBindingResolver {
    private final ProducerService producerService;
    private final StreamBindingService streamBindingService;

    @Override
    public Producer producer(ProducerBinding producerBinding) {
        return this.producerService.read(producerBinding.getKey().getProducerKey()).orElse(null);
    }

    @Override
    public StreamBinding binding(ProducerBinding producerBinding) {
        return this.streamBindingService.read(producerBinding.getKey().getStreamBindingKey()).orElse(null);
    }

    @ConstructorProperties(value={"producerService", "streamBindingService"})
    public ProducerBindingResolver(ProducerService producerService, StreamBindingService streamBindingService) {
        this.producerService = producerService;
        this.streamBindingService = streamBindingService;
    }
}

