/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.core.services.ProducerBindingService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.core.services.ZoneService;
import com.expediagroup.streamplatform.streamregistry.graphql.resolvers.Resolvers;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import com.expediagroup.streamplatform.streamregistry.model.ProducerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class ProducerResolver
implements Resolvers.ProducerResolver {
    private final StreamService streamService;
    private final ZoneService zoneService;
    private final ProducerBindingService producerBindingService;

    @Override
    public Stream stream(Producer producer) {
        return (Stream)this.streamService.read(producer.getKey().getStreamKey()).get();
    }

    @Override
    public Zone zone(Producer producer) {
        return this.zoneService.read(producer.getKey().getZoneKey()).orElse(null);
    }

    @Override
    public ProducerBinding binding(Producer producer) {
        return this.producerBindingService.find(producer.getKey()).orElse(null);
    }

    @ConstructorProperties(value={"streamService", "zoneService", "producerBindingService"})
    public ProducerResolver(StreamService streamService, ZoneService zoneService, ProducerBindingService producerBindingService) {
        this.streamService = streamService;
        this.zoneService = zoneService;
        this.producerBindingService = producerBindingService;
    }
}

