/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.graphql.GraphQLApiType;
import com.expediagroup.streamplatform.streamregistry.model.Consumer;
import com.expediagroup.streamplatform.streamregistry.model.ConsumerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Domain;
import com.expediagroup.streamplatform.streamregistry.model.Entity;
import com.expediagroup.streamplatform.streamregistry.model.Infrastructure;
import com.expediagroup.streamplatform.streamregistry.model.Producer;
import com.expediagroup.streamplatform.streamregistry.model.ProducerBinding;
import com.expediagroup.streamplatform.streamregistry.model.Schema;
import com.expediagroup.streamplatform.streamregistry.model.Status;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import com.expediagroup.streamplatform.streamregistry.model.Zone;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.kickstart.tools.GraphQLResolver;
import java.util.List;
import java.util.Optional;

interface Resolvers {

    public static interface EntityResolver<E extends Entity> {
        default public Status status(E entity) {
            return Optional.ofNullable(entity.getStatus()).orElseGet(Status::new);
        }
    }

    public static interface StatusResolver
    extends GraphQLResolver<Status>,
    GraphQLApiType {
        public ObjectNode getAgentStatus(Status var1);
    }

    public static interface ProducerBindingResolver
    extends EntityResolver<ProducerBinding>,
    GraphQLResolver<ProducerBinding>,
    GraphQLApiType {
        public Producer producer(ProducerBinding var1);

        public StreamBinding binding(ProducerBinding var1);
    }

    public static interface ConsumerBindingResolver
    extends EntityResolver<ConsumerBinding>,
    GraphQLResolver<ConsumerBinding>,
    GraphQLApiType {
        public Consumer consumer(ConsumerBinding var1);

        public StreamBinding binding(ConsumerBinding var1);
    }

    public static interface ConsumerResolver
    extends EntityResolver<Consumer>,
    GraphQLResolver<Consumer>,
    GraphQLApiType {
        public Stream stream(Consumer var1);

        public Zone zone(Consumer var1);

        public ConsumerBinding binding(Consumer var1);
    }

    public static interface ProducerResolver
    extends EntityResolver<Producer>,
    GraphQLResolver<Producer>,
    GraphQLApiType {
        public Stream stream(Producer var1);

        public Zone zone(Producer var1);

        public ProducerBinding binding(Producer var1);
    }

    public static interface StreamBindingResolver
    extends EntityResolver<StreamBinding>,
    GraphQLResolver<StreamBinding>,
    GraphQLApiType {
        public Stream stream(StreamBinding var1);

        public Infrastructure infrastructure(StreamBinding var1);
    }

    public static interface InfrastructureResolver
    extends EntityResolver<Infrastructure>,
    GraphQLResolver<Infrastructure>,
    GraphQLApiType {
        public Zone zone(Infrastructure var1);
    }

    public static interface ZoneResolver
    extends EntityResolver<Zone>,
    GraphQLResolver<Zone>,
    GraphQLApiType {
    }

    public static interface StreamResolver
    extends EntityResolver<Stream>,
    GraphQLResolver<Stream>,
    GraphQLApiType {
        public Domain domain(Stream var1);

        public Schema schema(Stream var1);
    }

    public static interface SchemaResolver
    extends EntityResolver<Schema>,
    GraphQLResolver<Schema>,
    GraphQLApiType {
        public Domain domain(Schema var1);
    }

    public static interface DomainResolver
    extends EntityResolver<Domain>,
    GraphQLResolver<Domain>,
    GraphQLApiType {
        public List<Schema> schemas(Domain var1);
    }
}

