/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.core.services.InfrastructureService;
import com.expediagroup.streamplatform.streamregistry.core.services.StreamService;
import com.expediagroup.streamplatform.streamregistry.graphql.resolvers.Resolvers;
import com.expediagroup.streamplatform.streamregistry.model.Infrastructure;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import com.expediagroup.streamplatform.streamregistry.model.StreamBinding;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class StreamBindingResolver
implements Resolvers.StreamBindingResolver {
    private final StreamService streamService;
    private final InfrastructureService infrastructureService;

    @Override
    public Stream stream(StreamBinding streamBinding) {
        return this.streamService.read(streamBinding.getKey().getStreamKey()).orElse(null);
    }

    @Override
    public Infrastructure infrastructure(StreamBinding streamBinding) {
        return this.infrastructureService.read(streamBinding.getKey().getInfrastructureKey()).orElse(null);
    }

    @ConstructorProperties(value={"streamService", "infrastructureService"})
    public StreamBindingResolver(StreamService streamService, InfrastructureService infrastructureService) {
        this.streamService = streamService;
        this.infrastructureService = infrastructureService;
    }
}

