/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.streamplatform.streamregistry.graphql.resolvers;

import com.expediagroup.streamplatform.streamregistry.core.services.DomainService;
import com.expediagroup.streamplatform.streamregistry.core.services.SchemaService;
import com.expediagroup.streamplatform.streamregistry.graphql.resolvers.Resolvers;
import com.expediagroup.streamplatform.streamregistry.model.Domain;
import com.expediagroup.streamplatform.streamregistry.model.Schema;
import com.expediagroup.streamplatform.streamregistry.model.Stream;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class StreamResolver
implements Resolvers.StreamResolver {
    private final DomainService domainService;
    private final SchemaService schemaService;

    @Override
    public Domain domain(Stream stream) {
        return this.domainService.read(stream.getKey().getDomainKey()).orElse(null);
    }

    @Override
    public Schema schema(Stream stream) {
        return this.schemaService.read(stream.getSchemaKey()).orElse(null);
    }

    @ConstructorProperties(value={"domainService", "schemaService"})
    public StreamResolver(DomainService domainService, SchemaService schemaService) {
        this.domainService = domainService;
        this.schemaService = schemaService;
    }
}

