/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.javadoc;

import com.google.common.io.Resources;
import io.takari.maven.testing.TestResources;
import io.takari.maven.testing.executor.MavenRuntime;
import io.takari.maven.testing.executor.MavenVersions;
import io.takari.maven.testing.executor.junit.MavenJUnitTestRunner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=MavenJUnitTestRunner.class)
@MavenVersions(value={"3.2.3", "3.3.9", "3.5.0"})
public class TestJavdocIntegration {
    @Rule
    public final TestResources resources = new TestResources();
    private final MavenRuntime maven;

    public TestJavdocIntegration(MavenRuntime.MavenRuntimeBuilder mavenBuilder) throws Exception {
        this.maven = mavenBuilder.withCliOptions(new String[]{"-B", "-U"}).build();
    }

    @Test
    public void testBasic() throws Exception {
        File basedir = this.resources.getBasedir("basic");
        this.maven.forProject(basedir).execute(new String[]{"compile"}).assertErrorFreeLog();
        TestJavdocIntegration.assertGenerated(basedir, "Fruit");
        TestJavdocIntegration.assertGenerated(basedir, "Point");
        TestJavdocIntegration.assertGenerated(basedir, "Response");
        TestJavdocIntegration.assertGenerated(basedir, "SimpleLogger");
    }

    private static void assertGenerated(File basedir, String name) throws IOException {
        URL expected = Resources.getResource((String)String.format("basic/%s.txt", name));
        name = name + "$DriftMeta";
        Assertions.assertThat((File)new File(basedir, String.format("target/classes/its/%s.class", name))).isFile();
        Assertions.assertThat((File)new File(basedir, String.format("target/generated-sources/annotations/its/%s.java", name))).usingCharset(StandardCharsets.UTF_8).hasContent(Resources.asCharSource((URL)expected, (Charset)StandardCharsets.UTF_8).read());
    }
}

