/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsAdmin {
    private DistributedFileSystem dfs;

    public HdfsAdmin(URI uri, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get(uri, conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("'" + uri + "' is not an HDFS URI.");
        }
        this.dfs = (DistributedFileSystem)fs;
    }

    public void setQuota(Path src, long quota) throws IOException {
        this.dfs.setQuota(src, quota, Long.MAX_VALUE);
    }

    public void clearQuota(Path src) throws IOException {
        this.dfs.setQuota(src, -1L, Long.MAX_VALUE);
    }

    public void setSpaceQuota(Path src, long spaceQuota) throws IOException {
        this.dfs.setQuota(src, Long.MAX_VALUE, spaceQuota);
    }

    public void clearSpaceQuota(Path src) throws IOException {
        this.dfs.setQuota(src, Long.MAX_VALUE, -1L);
    }

    public void setQuotaByStorageType(Path src, StorageType type, long quota) throws IOException {
        this.dfs.setQuotaByStorageType(src, type, quota);
    }

    public void clearQuotaByStorageType(Path src, StorageType type) throws IOException {
        this.dfs.setQuotaByStorageType(src, type, -1L);
    }

    public void allowSnapshot(Path path) throws IOException {
        this.dfs.allowSnapshot(path);
    }

    public void disallowSnapshot(Path path) throws IOException {
        this.dfs.disallowSnapshot(path);
    }

    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        return this.dfs.addCacheDirective(info, flags);
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        this.dfs.modifyCacheDirective(info, flags);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.dfs.removeCacheDirective(id);
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        return this.dfs.listCacheDirectives(filter);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.dfs.addCachePool(info);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.dfs.modifyCachePool(info);
    }

    public void removeCachePool(String poolName) throws IOException {
        this.dfs.removeCachePool(poolName);
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        return this.dfs.listCachePools();
    }

    public void createEncryptionZone(Path path, String keyName) throws IOException, AccessControlException, FileNotFoundException {
        this.dfs.createEncryptionZone(path, keyName);
    }

    public EncryptionZone getEncryptionZoneForPath(Path path) throws IOException, AccessControlException, FileNotFoundException {
        return this.dfs.getEZForPath(path);
    }

    public RemoteIterator<EncryptionZone> listEncryptionZones() throws IOException {
        return this.dfs.listEncryptionZones();
    }

    public DFSInotifyEventInputStream getInotifyEventStream() throws IOException {
        return this.dfs.getInotifyEventStream();
    }

    public DFSInotifyEventInputStream getInotifyEventStream(long lastReadTxid) throws IOException {
        return this.dfs.getInotifyEventStream(lastReadTxid);
    }

    public void setStoragePolicy(Path src, String policyName) throws IOException {
        this.dfs.setStoragePolicy(src, policyName);
    }
}

