/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.CommandLine;
import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.GnuParser;
import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.HelpFormatter;
import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.Option;
import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.OptionBuilder;
import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.Options;
import com.facebook.presto.hadoop.$internal.org.apache.commons.cli.ParseException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.ExitUtil;

@InterfaceAudience.Private
public class JMXGet {
    private static final String format = "%s=%s%n";
    private ArrayList<ObjectName> hadoopObjectNames;
    private MBeanServerConnection mbsc;
    private String service = "NameNode";
    private String port = "";
    private String server = "localhost";
    private String localVMUrl = null;

    public void setService(String service) {
        this.service = service;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setLocalVMUrl(String url) {
        this.localVMUrl = url;
    }

    public void printAllValues() throws Exception {
        JMXGet.err("List of all the available keys:");
        Object val = null;
        for (ObjectName oname : this.hadoopObjectNames) {
            MBeanAttributeInfo[] mbinfos;
            JMXGet.err(">>>>>>>>jmx name: " + oname.getCanonicalKeyPropertyListString());
            MBeanInfo mbinfo = this.mbsc.getMBeanInfo(oname);
            for (MBeanAttributeInfo mb : mbinfos = mbinfo.getAttributes()) {
                val = this.mbsc.getAttribute(oname, mb.getName());
                System.out.format(format, mb.getName(), val == null ? "" : val.toString());
            }
        }
    }

    public void printAllMatchedAttributes(String attrRegExp) throws Exception {
        JMXGet.err("List of the keys matching " + attrRegExp + " :");
        Object val = null;
        Pattern p = Pattern.compile(attrRegExp);
        for (ObjectName oname : this.hadoopObjectNames) {
            MBeanAttributeInfo[] mbinfos;
            JMXGet.err(">>>>>>>>jmx name: " + oname.getCanonicalKeyPropertyListString());
            MBeanInfo mbinfo = this.mbsc.getMBeanInfo(oname);
            for (MBeanAttributeInfo mb : mbinfos = mbinfo.getAttributes()) {
                if (!p.matcher(mb.getName()).lookingAt()) continue;
                val = this.mbsc.getAttribute(oname, mb.getName());
                System.out.format(format, mb.getName(), val == null ? "" : val.toString());
            }
        }
    }

    public String getValue(String key) throws Exception {
        Object val = null;
        for (ObjectName oname : this.hadoopObjectNames) {
            try {
                val = this.mbsc.getAttribute(oname, key);
            }
            catch (AttributeNotFoundException anfe) {
                continue;
            }
            catch (ReflectionException re) {
                if (re.getCause() instanceof NoSuchMethodException) continue;
            }
            JMXGet.err("Info: key = " + key + "; val = " + (val == null ? "null" : val.getClass()) + ":" + val);
            break;
        }
        return val == null ? "" : val.toString();
    }

    public void init() throws Exception {
        JMXGet.err("init: server=" + this.server + ";port=" + this.port + ";service=" + this.service + ";localVMUrl=" + this.localVMUrl);
        String url_string = null;
        if (this.localVMUrl != null) {
            url_string = this.localVMUrl;
            JMXGet.err("url string for local pid = " + this.localVMUrl + " = " + url_string);
        } else if (!this.port.isEmpty() && !this.server.isEmpty()) {
            url_string = "service:jmx:rmi:///jndi/rmi://" + this.server + ":" + this.port + "/jmxrmi";
        }
        if (url_string == null) {
            this.mbsc = ManagementFactory.getPlatformMBeanServer();
        } else {
            JMXServiceURL url = new JMXServiceURL(url_string);
            JMXGet.err("Create RMI connector and connect to the RMI connector server" + url);
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            JMXGet.err("\nGet an MBeanServerConnection");
            this.mbsc = jmxc.getMBeanServerConnection();
        }
        JMXGet.err("\nDomains:");
        Object[] domains = this.mbsc.getDomains();
        Arrays.sort(domains);
        for (Object domain : domains) {
            JMXGet.err("\tDomain = " + (String)domain);
        }
        JMXGet.err("\nMBeanServer default domain = " + this.mbsc.getDefaultDomain());
        JMXGet.err("\nMBean count = " + this.mbsc.getMBeanCount());
        ObjectName query = new ObjectName("Hadoop:service=" + this.service + ",*");
        this.hadoopObjectNames = new ArrayList(5);
        JMXGet.err("\nQuery MBeanServer MBeans:");
        TreeSet<ObjectName> names = new TreeSet<ObjectName>(this.mbsc.queryNames(query, null));
        for (ObjectName name : names) {
            this.hadoopObjectNames.add(name);
            JMXGet.err("Hadoop service: " + name);
        }
    }

    static void printUsage(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("jmxget options are: ", opts);
    }

    private static void err(String msg) {
        System.err.println(msg);
    }

    private static CommandLine parseArgs(Options opts, String ... args) throws IllegalArgumentException {
        OptionBuilder.withArgName("NameNode|DataNode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("specify jmx service (NameNode by default)");
        Option jmx_service = OptionBuilder.create("service");
        OptionBuilder.withArgName("mbean server");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("specify mbean server (localhost by default)");
        Option jmx_server = OptionBuilder.create("server");
        OptionBuilder.withDescription("print help");
        Option jmx_help = OptionBuilder.create("help");
        OptionBuilder.withArgName("mbean server port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("specify mbean server port, if missing - it will try to connect to MBean Server in the same VM");
        Option jmx_port = OptionBuilder.create("port");
        OptionBuilder.withArgName("VM's connector url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("connect to the VM on the same machine;\n use:\n jstat -J-Djstat.showUnsupported=true -snap <vmpid> | grep sun.management.JMXConnectorServer.address\n to find the url");
        Option jmx_localVM = OptionBuilder.create("localVM");
        opts.addOption(jmx_server);
        opts.addOption(jmx_help);
        opts.addOption(jmx_service);
        opts.addOption(jmx_port);
        opts.addOption(jmx_localVM);
        CommandLine commandLine = null;
        GnuParser parser = new GnuParser();
        try {
            commandLine = parser.parse(opts, args, true);
        }
        catch (ParseException e) {
            JMXGet.printUsage(opts);
            throw new IllegalArgumentException("invalid args: " + e.getMessage());
        }
        return commandLine;
    }

    public static void main(String[] args) {
        int res = -1;
        Options opts = new Options();
        CommandLine commandLine = null;
        try {
            commandLine = JMXGet.parseArgs(opts, args);
        }
        catch (IllegalArgumentException iae) {
            commandLine = null;
        }
        if (commandLine == null) {
            JMXGet.err("Invalid args");
            JMXGet.printUsage(opts);
            ExitUtil.terminate(-1);
        }
        JMXGet jm = new JMXGet();
        if (commandLine.hasOption("port")) {
            jm.setPort(commandLine.getOptionValue("port"));
        }
        if (commandLine.hasOption("service")) {
            jm.setService(commandLine.getOptionValue("service"));
        }
        if (commandLine.hasOption("server")) {
            jm.setServer(commandLine.getOptionValue("server"));
        }
        if (commandLine.hasOption("localVM")) {
            jm.setLocalVMUrl(commandLine.getOptionValue("localVM"));
        }
        if (commandLine.hasOption("help")) {
            JMXGet.printUsage(opts);
            ExitUtil.terminate(0);
        }
        args = commandLine.getArgs();
        try {
            jm.init();
            if (args.length == 0) {
                jm.printAllValues();
            } else {
                for (String key : args) {
                    JMXGet.err("key = " + key);
                    String val = jm.getValue(key);
                    if (val == null) continue;
                    System.out.format(format, key, val);
                }
            }
            res = 0;
        }
        catch (Exception re) {
            re.printStackTrace();
            res = -1;
        }
        ExitUtil.terminate(res);
    }
}

