/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import com.facebook.presto.hadoop.$internal.org.apache.commons.lang.SystemUtils;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SharedFileDescriptorFactory {
    public static final Log LOG = LogFactory.getLog(SharedFileDescriptorFactory.class);
    private final String prefix;
    private final String path;

    public static String getLoadingFailureReason() {
        if (!NativeIO.isAvailable()) {
            return "NativeIO is not available.";
        }
        if (!SystemUtils.IS_OS_UNIX) {
            return "The OS is not UNIX.";
        }
        return null;
    }

    public static SharedFileDescriptorFactory create(String prefix, String[] paths) throws IOException {
        String loadingFailureReason = SharedFileDescriptorFactory.getLoadingFailureReason();
        if (loadingFailureReason != null) {
            throw new IOException(loadingFailureReason);
        }
        if (paths.length == 0) {
            throw new IOException("no SharedFileDescriptorFactory paths were configured.");
        }
        StringBuilder errors = new StringBuilder();
        String strPrefix = "";
        for (String path : paths) {
            try {
                FileInputStream fis = new FileInputStream(SharedFileDescriptorFactory.createDescriptor0(prefix + "test", path, 1));
                fis.close();
                SharedFileDescriptorFactory.deleteStaleTemporaryFiles0(prefix, path);
                return new SharedFileDescriptorFactory(prefix, path);
            }
            catch (IOException e) {
                errors.append(strPrefix).append("Error creating file descriptor in ").append(path).append(": ").append(e.getMessage());
                strPrefix = ", ";
            }
        }
        throw new IOException(errors.toString());
    }

    private SharedFileDescriptorFactory(String prefix, String path) {
        this.prefix = prefix;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public FileInputStream createDescriptor(String info, int length) throws IOException {
        return new FileInputStream(SharedFileDescriptorFactory.createDescriptor0(this.prefix + info, this.path, length));
    }

    private static native void deleteStaleTemporaryFiles0(String var0, String var1) throws IOException;

    private static native FileDescriptor createDescriptor0(String var0, String var1, int var2) throws IOException;
}

