/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobClient
extends CLI {
    @InterfaceAudience.Private
    public static final String MAPREDUCE_CLIENT_RETRY_POLICY_ENABLED_KEY = "mapreduce.jobclient.retry.policy.enabled";
    @InterfaceAudience.Private
    public static final boolean MAPREDUCE_CLIENT_RETRY_POLICY_ENABLED_DEFAULT = false;
    @InterfaceAudience.Private
    public static final String MAPREDUCE_CLIENT_RETRY_POLICY_SPEC_KEY = "mapreduce.jobclient.retry.policy.spec";
    @InterfaceAudience.Private
    public static final String MAPREDUCE_CLIENT_RETRY_POLICY_SPEC_DEFAULT = "10000,6,60000,10";
    private TaskStatusFilter taskOutputFilter = TaskStatusFilter.FAILED;
    private int maxRetry = 0;
    private long retryInterval = 2000L;
    UserGroupInformation clientUgi;
    private static final TaskReport[] EMPTY_TASK_REPORTS;

    public JobClient() {
    }

    public JobClient(JobConf conf) throws IOException {
        this.init(conf);
    }

    public JobClient(Configuration conf) throws IOException {
        this.init(new JobConf(conf));
    }

    public void init(JobConf conf) throws IOException {
        this.setConf(conf);
        this.cluster = new Cluster(conf);
        this.clientUgi = UserGroupInformation.getCurrentUser();
        this.maxRetry = conf.getInt("yarn.app.mapreduce.client.job.max-retries", 0);
        this.retryInterval = conf.getLong("yarn.app.mapreduce.client.job.retry-interval", 2000L);
    }

    public JobClient(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.cluster = new Cluster(jobTrackAddr, conf);
        this.clientUgi = UserGroupInformation.getCurrentUser();
    }

    public synchronized void close() throws IOException {
        this.cluster.close();
    }

    public synchronized FileSystem getFs() throws IOException {
        try {
            return this.cluster.getFileSystem();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Cluster getClusterHandle() {
        return this.cluster;
    }

    public RunningJob submitJob(String jobFile) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobConf job = new JobConf(jobFile);
        return this.submitJob(job);
    }

    public RunningJob submitJob(JobConf conf) throws FileNotFoundException, IOException {
        return this.submitJobInternal(conf);
    }

    @InterfaceAudience.Private
    public RunningJob submitJobInternal(final JobConf conf) throws FileNotFoundException, IOException {
        try {
            conf.setBooleanIfUnset("mapred.mapper.new-api", false);
            conf.setBooleanIfUnset("mapred.reducer.new-api", false);
            Job job = this.clientUgi.doAs(new PrivilegedExceptionAction<Job>(){

                @Override
                public Job run() throws IOException, ClassNotFoundException, InterruptedException {
                    Job job = Job.getInstance(conf);
                    job.submit();
                    return job;
                }
            });
            this.cluster = job.getCluster();
            return new NetworkedJob(job);
        }
        catch (InterruptedException ie) {
            throw new IOException("interrupted", ie);
        }
    }

    private Job getJobUsingCluster(final JobID jobid) throws IOException, InterruptedException {
        return this.clientUgi.doAs(new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws IOException, InterruptedException {
                return JobClient.this.cluster.getJob(jobid);
            }
        });
    }

    protected RunningJob getJobInner(JobID jobid) throws IOException {
        try {
            org.apache.hadoop.mapred.JobStatus status;
            Job job = this.getJobUsingCluster(jobid);
            if (job != null && (status = org.apache.hadoop.mapred.JobStatus.downgrade(job.getStatus())) != null) {
                return new NetworkedJob(status, this.cluster, new JobConf(job.getConfiguration()));
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return null;
    }

    public RunningJob getJob(JobID jobid) throws IOException {
        for (int i = 0; i <= this.maxRetry; ++i) {
            RunningJob job;
            if (i > 0) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((job = this.getJobInner(jobid)) == null) continue;
            return job;
        }
        return null;
    }

    @Deprecated
    public RunningJob getJob(String jobid) throws IOException {
        return this.getJob(JobID.forName(jobid));
    }

    public TaskReport[] getMapTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.MAP);
    }

    private TaskReport[] getTaskReports(JobID jobId, TaskType type) throws IOException {
        try {
            Job j = this.getJobUsingCluster(jobId);
            if (j == null) {
                return EMPTY_TASK_REPORTS;
            }
            return TaskReport.downgradeArray(j.getTaskReports(type));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Deprecated
    public TaskReport[] getMapTaskReports(String jobId) throws IOException {
        return this.getMapTaskReports(JobID.forName(jobId));
    }

    public TaskReport[] getReduceTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.REDUCE);
    }

    public TaskReport[] getCleanupTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.JOB_CLEANUP);
    }

    public TaskReport[] getSetupTaskReports(JobID jobId) throws IOException {
        return this.getTaskReports(jobId, TaskType.JOB_SETUP);
    }

    @Deprecated
    public TaskReport[] getReduceTaskReports(String jobId) throws IOException {
        return this.getReduceTaskReports(JobID.forName(jobId));
    }

    public void displayTasks(JobID jobId, String type, String state) throws IOException {
        try {
            Job job = this.getJobUsingCluster(jobId);
            super.displayTasks(job, type, state);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<ClusterStatus>(){

                @Override
                public ClusterStatus run() throws IOException, InterruptedException {
                    ClusterMetrics metrics = JobClient.this.cluster.getClusterStatus();
                    return new ClusterStatus(metrics.getTaskTrackerCount(), metrics.getBlackListedTaskTrackerCount(), JobClient.this.cluster.getTaskTrackerExpiryInterval(), metrics.getOccupiedMapSlots(), metrics.getOccupiedReduceSlots(), metrics.getMapSlotCapacity(), metrics.getReduceSlotCapacity(), JobClient.this.cluster.getJobTrackerStatus(), metrics.getDecommissionedTaskTrackerCount(), metrics.getGrayListedTaskTrackerCount());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private Collection<String> arrayToStringList(TaskTrackerInfo[] objs) {
        ArrayList<String> list = new ArrayList<String>();
        for (TaskTrackerInfo info : objs) {
            list.add(info.getTaskTrackerName());
        }
        return list;
    }

    private Collection<ClusterStatus.BlackListInfo> arrayToBlackListInfo(TaskTrackerInfo[] objs) {
        ArrayList<ClusterStatus.BlackListInfo> list = new ArrayList<ClusterStatus.BlackListInfo>();
        for (TaskTrackerInfo info : objs) {
            ClusterStatus.BlackListInfo binfo = new ClusterStatus.BlackListInfo();
            binfo.setTrackerName(info.getTaskTrackerName());
            binfo.setReasonForBlackListing(info.getReasonForBlacklist());
            binfo.setBlackListReport(info.getBlacklistReport());
            list.add(binfo);
        }
        return list;
    }

    public ClusterStatus getClusterStatus(boolean detailed) throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<ClusterStatus>(){

                @Override
                public ClusterStatus run() throws IOException, InterruptedException {
                    ClusterMetrics metrics = JobClient.this.cluster.getClusterStatus();
                    return new ClusterStatus(JobClient.this.arrayToStringList(JobClient.this.cluster.getActiveTaskTrackers()), JobClient.this.arrayToBlackListInfo(JobClient.this.cluster.getBlackListedTaskTrackers()), JobClient.this.cluster.getTaskTrackerExpiryInterval(), metrics.getOccupiedMapSlots(), metrics.getOccupiedReduceSlots(), metrics.getMapSlotCapacity(), metrics.getReduceSlotCapacity(), JobClient.this.cluster.getJobTrackerStatus());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.JobStatus[] jobsToComplete() throws IOException {
        ArrayList<org.apache.hadoop.mapred.JobStatus> stats = new ArrayList<org.apache.hadoop.mapred.JobStatus>();
        for (org.apache.hadoop.mapred.JobStatus stat : this.getAllJobs()) {
            if (stat.isJobComplete()) continue;
            stats.add(stat);
        }
        return stats.toArray(new org.apache.hadoop.mapred.JobStatus[0]);
    }

    public org.apache.hadoop.mapred.JobStatus[] getAllJobs() throws IOException {
        try {
            JobStatus[] jobs = this.clientUgi.doAs(new PrivilegedExceptionAction<JobStatus[]>(){

                @Override
                public JobStatus[] run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getAllJobStatuses();
                }
            });
            org.apache.hadoop.mapred.JobStatus[] stats = new org.apache.hadoop.mapred.JobStatus[jobs.length];
            for (int i = 0; i < jobs.length; ++i) {
                stats[i] = org.apache.hadoop.mapred.JobStatus.downgrade(jobs[i]);
            }
            return stats;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        RunningJob rj = jc.submitJob(job);
        try {
            if (!jc.monitorAndPrintJob(job, rj)) {
                throw new IOException("Job failed!");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return rj;
    }

    public boolean monitorAndPrintJob(JobConf conf, RunningJob job) throws IOException, InterruptedException {
        return ((NetworkedJob)job).monitorAndPrintJob();
    }

    static String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&attemptid=" + taskId;
    }

    static Configuration getConfiguration(String jobTrackerSpec) {
        Configuration conf = new Configuration();
        if (jobTrackerSpec != null) {
            if (jobTrackerSpec.indexOf(":") >= 0) {
                conf.set("mapred.job.tracker", jobTrackerSpec);
            } else {
                String classpathFile = "hadoop-" + jobTrackerSpec + ".xml";
                URL validate = conf.getResource(classpathFile);
                if (validate == null) {
                    throw new RuntimeException(classpathFile + " not found on CLASSPATH");
                }
                conf.addResource(classpathFile);
            }
        }
        return conf;
    }

    @Deprecated
    public void setTaskOutputFilter(TaskStatusFilter newValue) {
        this.taskOutputFilter = newValue;
    }

    public static TaskStatusFilter getTaskOutputFilter(JobConf job) {
        return TaskStatusFilter.valueOf(job.get("jobclient.output.filter", "FAILED"));
    }

    public static void setTaskOutputFilter(JobConf job, TaskStatusFilter newValue) {
        job.set("jobclient.output.filter", newValue.toString());
    }

    @Deprecated
    public TaskStatusFilter getTaskOutputFilter() {
        return this.taskOutputFilter;
    }

    @Override
    protected long getCounter(Counters cntrs, String counterGroupName, String counterName) throws IOException {
        org.apache.hadoop.mapred.Counters counters = org.apache.hadoop.mapred.Counters.downgrade(cntrs);
        return counters.findCounter(counterGroupName, counterName).getValue();
    }

    public int getDefaultMaps() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getClusterStatus().getMapSlotCapacity();
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public int getDefaultReduces() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getClusterStatus().getReduceSlotCapacity();
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Path getSystemDir() {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<Path>(){

                @Override
                public Path run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getSystemDir();
                }
            });
        }
        catch (IOException ioe) {
            return null;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public static boolean isJobDirValid(Path jobDirPath, FileSystem fs) throws IOException {
        FileStatus[] contents = fs.listStatus(jobDirPath);
        int matchCount = 0;
        if (contents != null && contents.length >= 2) {
            for (FileStatus status : contents) {
                if ("job.xml".equals(status.getPath().getName())) {
                    ++matchCount;
                }
                if (!"job.split".equals(status.getPath().getName())) continue;
                ++matchCount;
            }
            if (matchCount == 2) {
                return true;
            }
        }
        return false;
    }

    public Path getStagingAreaDir() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<Path>(){

                @Override
                public Path run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getStagingAreaDir();
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private JobQueueInfo getJobQueueInfo(QueueInfo queue) {
        JobQueueInfo ret = new JobQueueInfo(queue);
        if (queue.getQueueChildren().size() > 0) {
            ArrayList<JobQueueInfo> childQueues = new ArrayList<JobQueueInfo>(queue.getQueueChildren().size());
            for (QueueInfo child : queue.getQueueChildren()) {
                childQueues.add(this.getJobQueueInfo(child));
            }
            ret.setChildren(childQueues);
        }
        return ret;
    }

    private JobQueueInfo[] getJobQueueInfoArray(QueueInfo[] queues) throws IOException {
        JobQueueInfo[] ret = new JobQueueInfo[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            ret[i] = this.getJobQueueInfo(queues[i]);
        }
        return ret;
    }

    public JobQueueInfo[] getRootQueues() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<JobQueueInfo[]>(){

                @Override
                public JobQueueInfo[] run() throws IOException, InterruptedException {
                    return JobClient.this.getJobQueueInfoArray(JobClient.this.cluster.getRootQueues());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo[] getChildQueues(final String queueName) throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<JobQueueInfo[]>(){

                @Override
                public JobQueueInfo[] run() throws IOException, InterruptedException {
                    return JobClient.this.getJobQueueInfoArray(JobClient.this.cluster.getChildQueues(queueName));
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo[] getQueues() throws IOException {
        try {
            return this.clientUgi.doAs(new PrivilegedExceptionAction<JobQueueInfo[]>(){

                @Override
                public JobQueueInfo[] run() throws IOException, InterruptedException {
                    return JobClient.this.getJobQueueInfoArray(JobClient.this.cluster.getQueues());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.JobStatus[] getJobsFromQueue(final String queueName) throws IOException {
        try {
            QueueInfo queue = this.clientUgi.doAs(new PrivilegedExceptionAction<QueueInfo>(){

                @Override
                public QueueInfo run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getQueue(queueName);
                }
            });
            if (queue == null) {
                return null;
            }
            JobStatus[] stats = queue.getJobStatuses();
            org.apache.hadoop.mapred.JobStatus[] ret = new org.apache.hadoop.mapred.JobStatus[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                ret[i] = org.apache.hadoop.mapred.JobStatus.downgrade(stats[i]);
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo getQueueInfo(final String queueName) throws IOException {
        try {
            QueueInfo queueInfo = this.clientUgi.doAs(new PrivilegedExceptionAction<QueueInfo>(){

                @Override
                public QueueInfo run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getQueue(queueName);
                }
            });
            if (queueInfo != null) {
                return new JobQueueInfo(queueInfo);
            }
            return null;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        try {
            org.apache.hadoop.mapreduce.QueueAclsInfo[] acls = this.clientUgi.doAs(new PrivilegedExceptionAction<org.apache.hadoop.mapreduce.QueueAclsInfo[]>(){

                @Override
                public org.apache.hadoop.mapreduce.QueueAclsInfo[] run() throws IOException, InterruptedException {
                    return JobClient.this.cluster.getQueueAclsForCurrentUser();
                }
            });
            QueueAclsInfo[] ret = new QueueAclsInfo[acls.length];
            for (int i = 0; i < acls.length; ++i) {
                ret[i] = QueueAclsInfo.downgrade(acls[i]);
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(final Text renewer) throws IOException, InterruptedException {
        return this.clientUgi.doAs(new PrivilegedExceptionAction<Token<DelegationTokenIdentifier>>(){

            @Override
            public Token<DelegationTokenIdentifier> run() throws IOException, InterruptedException {
                return JobClient.this.cluster.getDelegationToken(renewer);
            }
        });
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        return token.renew(this.getConf());
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        token.cancel(this.getConf());
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new JobClient(), argv);
        System.exit(res);
    }

    static {
        ConfigUtil.loadResources();
        EMPTY_TASK_REPORTS = new TaskReport[0];
    }

    static class NetworkedJob
    implements RunningJob {
        Job job;

        public NetworkedJob(org.apache.hadoop.mapred.JobStatus status, Cluster cluster) throws IOException {
            this(status, cluster, new JobConf(status.getJobFile()));
        }

        private NetworkedJob(org.apache.hadoop.mapred.JobStatus status, Cluster cluster, JobConf conf) throws IOException {
            this(Job.getInstance(cluster, status, conf));
        }

        public NetworkedJob(Job job) throws IOException {
            this.job = job;
        }

        @Override
        public Configuration getConfiguration() {
            return this.job.getConfiguration();
        }

        @Override
        public JobID getID() {
            return JobID.downgrade(this.job.getJobID());
        }

        @Override
        @Deprecated
        public String getJobID() {
            return this.getID().toString();
        }

        @Override
        public String getJobName() {
            return this.job.getJobName();
        }

        @Override
        public String getJobFile() {
            return this.job.getJobFile();
        }

        @Override
        public String getTrackingURL() {
            return this.job.getTrackingURL();
        }

        @Override
        public float mapProgress() throws IOException {
            return this.job.mapProgress();
        }

        @Override
        public float reduceProgress() throws IOException {
            return this.job.reduceProgress();
        }

        @Override
        public float cleanupProgress() throws IOException {
            try {
                return this.job.cleanupProgress();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public float setupProgress() throws IOException {
            return this.job.setupProgress();
        }

        @Override
        public synchronized boolean isComplete() throws IOException {
            return this.job.isComplete();
        }

        @Override
        public synchronized boolean isSuccessful() throws IOException {
            return this.job.isSuccessful();
        }

        @Override
        public void waitForCompletion() throws IOException {
            try {
                this.job.waitForCompletion(false);
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
            catch (ClassNotFoundException ce) {
                throw new IOException(ce);
            }
        }

        @Override
        public synchronized int getJobState() throws IOException {
            try {
                return this.job.getJobState().getValue();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized void killJob() throws IOException {
            this.job.killJob();
        }

        @Override
        public synchronized void setJobPriority(String priority) throws IOException {
            try {
                this.job.setPriority(JobPriority.valueOf(priority));
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized void killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
            if (shouldFail) {
                this.job.failTask(taskId);
            } else {
                this.job.killTask(taskId);
            }
        }

        @Override
        @Deprecated
        public synchronized void killTask(String taskId, boolean shouldFail) throws IOException {
            this.killTask(TaskAttemptID.forName(taskId), shouldFail);
        }

        @Override
        public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
            try {
                org.apache.hadoop.mapreduce.TaskCompletionEvent[] acls = this.job.getTaskCompletionEvents(startFrom, 10);
                TaskCompletionEvent[] ret = new TaskCompletionEvent[acls.length];
                for (int i = 0; i < acls.length; ++i) {
                    ret[i] = TaskCompletionEvent.downgrade(acls[i]);
                }
                return ret;
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        public String toString() {
            return this.job.toString();
        }

        @Override
        public org.apache.hadoop.mapred.Counters getCounters() throws IOException {
            org.apache.hadoop.mapred.Counters result = null;
            Counters temp = this.job.getCounters();
            if (temp != null) {
                result = org.apache.hadoop.mapred.Counters.downgrade(temp);
            }
            return result;
        }

        @Override
        public String[] getTaskDiagnostics(TaskAttemptID id) throws IOException {
            try {
                return this.job.getTaskDiagnostics(id);
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public String getHistoryUrl() throws IOException {
            try {
                return this.job.getHistoryUrl();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public boolean isRetired() throws IOException {
            try {
                return this.job.isRetired();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        boolean monitorAndPrintJob() throws IOException, InterruptedException {
            return this.job.monitorAndPrintJob();
        }

        @Override
        public String getFailureInfo() throws IOException {
            try {
                return this.job.getStatus().getFailureInfo();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public org.apache.hadoop.mapred.JobStatus getJobStatus() throws IOException {
            try {
                return org.apache.hadoop.mapred.JobStatus.downgrade(this.job.getStatus());
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
    }

    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }
}

