/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

class JobQueueClient
extends Configured
implements Tool {
    JobClient jc;

    public JobQueueClient() {
    }

    public JobQueueClient(JobConf conf) throws IOException {
        this.setConf(conf);
    }

    private void init(JobConf conf) throws IOException {
        this.setConf(conf);
        this.jc = new JobClient(conf);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int run(String[] argv) throws Exception {
        int exitcode = -1;
        if (argv.length < 1) {
            this.displayUsage("");
            return exitcode;
        }
        String cmd = argv[0];
        boolean displayQueueList = false;
        boolean displayQueueInfoWithJobs = false;
        boolean displayQueueInfoWithoutJobs = false;
        boolean displayQueueAclsInfoForCurrentUser = false;
        if ("-list".equals(cmd)) {
            displayQueueList = true;
        } else if ("-showacls".equals(cmd)) {
            displayQueueAclsInfoForCurrentUser = true;
        } else {
            if (!"-info".equals(cmd)) {
                this.displayUsage(cmd);
                return exitcode;
            }
            if (argv.length == 2 && !argv[1].equals("-showJobs")) {
                displayQueueInfoWithoutJobs = true;
            } else {
                if (argv.length != 3) {
                    this.displayUsage(cmd);
                    return exitcode;
                }
                if (!argv[2].equals("-showJobs")) {
                    this.displayUsage(cmd);
                    return exitcode;
                }
                displayQueueInfoWithJobs = true;
            }
        }
        JobConf conf = new JobConf(this.getConf());
        this.init(conf);
        if (displayQueueList) {
            this.displayQueueList();
            return 0;
        }
        if (displayQueueInfoWithoutJobs) {
            this.displayQueueInfo(argv[1], false);
            return 0;
        }
        if (displayQueueInfoWithJobs) {
            this.displayQueueInfo(argv[1], true);
            return 0;
        }
        if (!displayQueueAclsInfoForCurrentUser) return exitcode;
        this.displayQueueAclsInfoForCurrentUser();
        return 0;
    }

    void printJobQueueInfo(JobQueueInfo jobQueueInfo, Writer writer) throws IOException {
        this.printJobQueueInfo(jobQueueInfo, writer, "");
    }

    void printJobQueueInfo(JobQueueInfo jobQueueInfo, Writer writer, String prefix) throws IOException {
        if (jobQueueInfo == null) {
            writer.write("No queue found.\n");
            writer.flush();
            return;
        }
        writer.write(String.format(prefix + "======================\n", new Object[0]));
        writer.write(String.format(prefix + "Queue Name : %s \n", jobQueueInfo.getQueueName()));
        writer.write(String.format(prefix + "Queue State : %s \n", jobQueueInfo.getQueueState()));
        writer.write(String.format(prefix + "Scheduling Info : %s \n", jobQueueInfo.getSchedulingInfo()));
        List<JobQueueInfo> childQueues = jobQueueInfo.getChildren();
        if (childQueues != null && childQueues.size() > 0) {
            for (int i = 0; i < childQueues.size(); ++i) {
                this.printJobQueueInfo(childQueues.get(i), writer, "    " + prefix);
            }
        }
        writer.flush();
    }

    private void displayQueueList() throws IOException {
        JobQueueInfo[] rootQueues;
        for (JobQueueInfo queue : rootQueues = this.jc.getRootQueues()) {
            this.printJobQueueInfo(queue, new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8)));
        }
    }

    List<JobQueueInfo> expandQueueList(JobQueueInfo[] rootQueues) {
        ArrayList<JobQueueInfo> allQueues = new ArrayList<JobQueueInfo>();
        for (JobQueueInfo queue : rootQueues) {
            allQueues.add(queue);
            if (queue.getChildren() == null) continue;
            JobQueueInfo[] childQueues = queue.getChildren().toArray(new JobQueueInfo[0]);
            allQueues.addAll(this.expandQueueList(childQueues));
        }
        return allQueues;
    }

    private void displayQueueInfo(String queue, boolean showJobs) throws IOException, InterruptedException {
        JobQueueInfo jobQueueInfo = this.jc.getQueueInfo(queue);
        if (jobQueueInfo == null) {
            System.out.println("Queue \"" + queue + "\" does not exist.");
            return;
        }
        this.printJobQueueInfo(jobQueueInfo, new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8)));
        if (showJobs && (jobQueueInfo.getChildren() == null || jobQueueInfo.getChildren().size() == 0)) {
            JobStatus[] jobs = jobQueueInfo.getJobStatuses();
            if (jobs == null) {
                jobs = new JobStatus[]{};
            }
            this.jc.displayJobList(jobs);
        }
    }

    private void displayQueueAclsInfoForCurrentUser() throws IOException {
        QueueAclsInfo[] queueAclsInfoList = this.jc.getQueueAclsForCurrentUser();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        if (queueAclsInfoList.length > 0) {
            System.out.println("Queue acls for user :  " + ugi.getShortUserName());
            System.out.println("\nQueue  Operations");
            System.out.println("=====================");
            for (QueueAclsInfo queueInfo : queueAclsInfoList) {
                System.out.print(queueInfo.getQueueName() + "  ");
                Object[] ops = queueInfo.getOperations();
                Arrays.sort(ops);
                int max = ops.length - 1;
                for (int j = 0; j < ops.length; ++j) {
                    System.out.print(((String)ops[j]).replaceFirst("acl-", ""));
                    if (j >= max) continue;
                    System.out.print(",");
                }
                System.out.println();
            }
        } else {
            System.out.println("User " + ugi.getShortUserName() + " does not have access to any queue. \n");
        }
    }

    private void displayUsage(String cmd) {
        String prefix = "Usage: JobQueueClient ";
        if ("-queueinfo".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "<job-queue-name> [-showJobs]]");
        } else {
            System.err.printf(prefix + "<command> <args>%n", new Object[0]);
            System.err.printf("\t[-list]%n", new Object[0]);
            System.err.printf("\t[-info <job-queue-name> [-showJobs]]%n", new Object[0]);
            System.err.printf("\t[-showacls] %n%n", new Object[0]);
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new JobQueueClient(), argv);
        System.exit(res);
    }
}

